/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.omdom.element;

import java.io.Reader;
import java.io.StringReader;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.ts.AxiomTestCase;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TestReplaceChildMiddleIncomplete
extends AxiomTestCase {
    public TestReplaceChildMiddleIncomplete(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        Element element = (Element)OMXMLBuilderFactory.createOMBuilder((OMFactory)factory, (Reader)new StringReader("<root><a/><b/><c/></root>")).getDocumentElement();
        Element a = (Element)element.getFirstChild();
        Element b = (Element)a.getNextSibling();
        Element b2 = element.getOwnerDocument().createElementNS(null, "b2");
        element.replaceChild(b2, b);
        Element c = (Element)b2.getNextSibling();
        TestReplaceChildMiddleIncomplete.assertNotNull((Object)c);
        TestReplaceChildMiddleIncomplete.assertNull((Object)a.getPreviousSibling());
        TestReplaceChildMiddleIncomplete.assertSame((Object)b2, (Object)a.getNextSibling());
        TestReplaceChildMiddleIncomplete.assertSame((Object)a, (Object)b2.getPreviousSibling());
        TestReplaceChildMiddleIncomplete.assertSame((Object)b2, (Object)c.getPreviousSibling());
        TestReplaceChildMiddleIncomplete.assertNull((Object)c.getNextSibling());
        TestReplaceChildMiddleIncomplete.assertSame((Object)a, (Object)element.getFirstChild());
        TestReplaceChildMiddleIncomplete.assertSame((Object)c, (Object)element.getLastChild());
        TestReplaceChildMiddleIncomplete.assertSame((Object)element, (Object)a.getParentNode());
        TestReplaceChildMiddleIncomplete.assertSame((Object)element, (Object)b2.getParentNode());
        TestReplaceChildMiddleIncomplete.assertSame((Object)element, (Object)c.getParentNode());
        NodeList children = element.getChildNodes();
        TestReplaceChildMiddleIncomplete.assertEquals((int)3, (int)children.getLength());
        TestReplaceChildMiddleIncomplete.assertSame((Object)a, (Object)children.item(0));
        TestReplaceChildMiddleIncomplete.assertSame((Object)b2, (Object)children.item(1));
        TestReplaceChildMiddleIncomplete.assertSame((Object)c, (Object)children.item(2));
        TestReplaceChildMiddleIncomplete.assertNull((Object)b.getPreviousSibling());
        TestReplaceChildMiddleIncomplete.assertNull((Object)b.getNextSibling());
        TestReplaceChildMiddleIncomplete.assertNull((Object)b.getParentNode());
    }
}

