/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.omdom.element;

import java.io.Reader;
import java.io.StringReader;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.ts.AxiomTestCase;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TestReplaceChildFirstIncomplete
extends AxiomTestCase {
    public TestReplaceChildFirstIncomplete(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        Element element = (Element)OMXMLBuilderFactory.createOMBuilder((OMFactory)factory, (Reader)new StringReader("<root><a/><b/><c/></root>")).getDocumentElement();
        Element a = (Element)element.getFirstChild();
        Element a2 = element.getOwnerDocument().createElementNS(null, "a2");
        element.replaceChild(a2, a);
        Element b = (Element)a2.getNextSibling();
        TestReplaceChildFirstIncomplete.assertNotNull((Object)b);
        Element c = (Element)b.getNextSibling();
        TestReplaceChildFirstIncomplete.assertNotNull((Object)c);
        TestReplaceChildFirstIncomplete.assertNull((Object)a2.getPreviousSibling());
        TestReplaceChildFirstIncomplete.assertSame((Object)a2, (Object)b.getPreviousSibling());
        TestReplaceChildFirstIncomplete.assertSame((Object)b, (Object)c.getPreviousSibling());
        TestReplaceChildFirstIncomplete.assertNull((Object)c.getNextSibling());
        TestReplaceChildFirstIncomplete.assertSame((Object)a2, (Object)element.getFirstChild());
        TestReplaceChildFirstIncomplete.assertSame((Object)c, (Object)element.getLastChild());
        TestReplaceChildFirstIncomplete.assertSame((Object)element, (Object)a2.getParentNode());
        TestReplaceChildFirstIncomplete.assertSame((Object)element, (Object)b.getParentNode());
        TestReplaceChildFirstIncomplete.assertSame((Object)element, (Object)c.getParentNode());
        NodeList children = element.getChildNodes();
        TestReplaceChildFirstIncomplete.assertEquals((int)3, (int)children.getLength());
        TestReplaceChildFirstIncomplete.assertSame((Object)a2, (Object)children.item(0));
        TestReplaceChildFirstIncomplete.assertSame((Object)b, (Object)children.item(1));
        TestReplaceChildFirstIncomplete.assertSame((Object)c, (Object)children.item(2));
        TestReplaceChildFirstIncomplete.assertNull((Object)a.getPreviousSibling());
        TestReplaceChildFirstIncomplete.assertNull((Object)a.getNextSibling());
        TestReplaceChildFirstIncomplete.assertNull((Object)a.getParentNode());
    }
}

