/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.xop;

import com.google.common.truth.Truth;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.xerces.impl.dv.util.Base64;

public class TestSetOptimizePlainOMText
extends AxiomTestCase {
    public TestSetOptimizePlainOMText(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMElement element = factory.createOMElement("element", null);
        OMText text = factory.createOMText((OMContainer)element, Base64.encode((byte[])"foobar".getBytes(StandardCharsets.UTF_8)));
        text.setOptimize(true);
        OMOutputFormat format = new OMOutputFormat();
        format.setDoOptimize(true);
        StringWriter sw = new StringWriter();
        WriterOutputStream out = new WriterOutputStream((Writer)sw, StandardCharsets.UTF_8);
        element.serialize((OutputStream)out, format, true);
        out.close();
        Truth.assertThat((String)sw.toString()).contains((CharSequence)"foobar");
    }
}

