/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.xop;

import com.google.common.truth.Truth;
import jakarta.activation.DataSource;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.axiom.mime.MultipartBody;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMSerializable;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.xml.XOPSample;

public class TestSetOptimize
extends AxiomTestCase {
    private final boolean optimize;

    public TestSetOptimize(OMMetaFactory metaFactory, boolean optimize) {
        super(metaFactory);
        this.optimize = optimize;
        this.addTestParameter("optimize", optimize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Throwable {
        try (InputStream in = XOPSample.XOP_SPEC_SAMPLE.getInputStream();){
            OMDocument document = OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (StAXParserConfiguration)StAXParserConfiguration.DEFAULT, (MultipartBody)MultipartBody.builder().setInputStream(in).setContentType(XOPSample.XOP_SPEC_SAMPLE.getContentType()).build()).getDocument();
            Iterator it = document.getDescendants(false);
            while (it.hasNext()) {
                OMText text;
                OMSerializable node = (OMSerializable)it.next();
                if (!(node instanceof OMText) || !(text = (OMText)node).isBinary()) continue;
                text.setOptimize(this.optimize);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OMOutputFormat format = new OMOutputFormat();
            format.setDoOptimize(true);
            document.serialize((OutputStream)out, format);
            MimeMultipart mp = new MimeMultipart((DataSource)new ByteArrayDataSource(out.toByteArray(), format.getContentType()));
            Truth.assertThat((Integer)mp.getCount()).isEqualTo((Object)(this.optimize ? 3 : 1));
        }
    }
}

