/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.text;

import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMText;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.util.xml.stream.XMLEventUtils;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSerialize
extends AxiomTestCase {
    private final int type;

    public TestSerialize(OMMetaFactory metaFactory, int type) {
        super(metaFactory);
        this.type = type;
        this.addTestParameter("type", XMLEventUtils.getEventTypeString((int)type));
    }

    protected void runTest() throws Throwable {
        OMText text = this.metaFactory.getOMFactory().createOMText("test", this.type);
        XMLStreamWriter writer = (XMLStreamWriter)Mockito.mock(XMLStreamWriter.class);
        text.serialize(writer);
        if (this.type == 12) {
            ((XMLStreamWriter)Mockito.verify((Object)writer)).writeCData(text.getText());
        } else {
            ((XMLStreamWriter)Mockito.verify((Object)writer)).writeCharacters(text.getText());
        }
        ((XMLStreamWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.atMost((int)1))).flush();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{writer});
    }
}

