/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.text;

import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.testutils.blob.RandomBlob;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.om.text.DummyAttachmentAccessor;

public class TestCloneBinary
extends AxiomTestCase {
    private boolean fetch;

    public TestCloneBinary(OMMetaFactory metaFactory, boolean fetch) {
        super(metaFactory);
        this.fetch = fetch;
        this.addTestParameter("fetch", fetch);
    }

    protected void runTest() throws Throwable {
        RandomBlob blob = new RandomBlob(600613L, 4096L);
        StringReader rootPart = new StringReader("<root><xop:Include xmlns:xop='http://www.w3.org/2004/08/xop/include' href='cid:123456@example.org'/></root>");
        DummyAttachmentAccessor attachmentAccessor = new DummyAttachmentAccessor("123456@example.org", (Blob)blob);
        OMElement root = OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (Source)new StreamSource(rootPart), (OMAttachmentAccessor)attachmentAccessor).getDocumentElement();
        OMText text = (OMText)root.getFirstOMChild();
        OMCloneOptions options = new OMCloneOptions();
        options.setFetchBlobs(this.fetch);
        OMText clone = (OMText)text.clone(options);
        TestCloneBinary.assertTrue((boolean)clone.isBinary());
        TestCloneBinary.assertEquals((boolean)this.fetch, (boolean)attachmentAccessor.isLoaded());
        TestCloneBinary.assertSame((Object)blob, (Object)clone.getBlob());
    }
}

