/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement.push;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.testutils.suite.MatrixTestCase;
import org.apache.axiom.ts.om.sourcedelement.push.PushOMDataSourceScenario;
import org.junit.Assert;

public class WriteNamespaceScenario
implements PushOMDataSourceScenario {
    private final String prefix;
    private final String namespaceURI;

    public WriteNamespaceScenario(String prefix, String namespaceURI) {
        this.prefix = prefix;
        this.namespaceURI = namespaceURI;
    }

    public void addTestParameters(MatrixTestCase testCase) {
        testCase.addTestParameter("scenario", "writeNamespace");
        testCase.addTestParameter("prefix", this.prefix);
        testCase.addTestParameter("uri", this.namespaceURI);
    }

    @Override
    public Map<String, String> getNamespaceContext() {
        return Collections.emptyMap();
    }

    @Override
    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("_p_", "root", "urn:__test__");
        writer.writeNamespace("_p_", "urn:__test__");
        writer.writeNamespace(this.prefix, this.namespaceURI);
        writer.writeEndElement();
    }

    @Override
    public void validate(OMElement element, boolean blobsPreserved) throws Throwable {
        OMNamespace decl = null;
        Iterator it = element.getAllDeclaredNamespaces();
        while (it.hasNext()) {
            OMNamespace ns = (OMNamespace)it.next();
            if (ns.getPrefix().equals("_p_")) continue;
            if (decl != null) {
                Assert.fail((String)"Found unexpected namespace declaration");
                continue;
            }
            decl = ns;
        }
        Assert.assertNotNull(decl);
        Assert.assertEquals((Object)this.prefix, (Object)decl.getPrefix());
        Assert.assertEquals((Object)this.namespaceURI, (Object)decl.getNamespaceURI());
    }
}

