/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement.push;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.testutils.blob.RandomBlob;
import org.apache.axiom.testutils.io.IOTestUtils;
import org.apache.axiom.testutils.suite.MatrixTestCase;
import org.apache.axiom.ts.om.sourcedelement.push.PushOMDataSourceScenario;
import org.apache.axiom.util.stax.XMLStreamWriterUtils;
import org.junit.Assert;

public class WriteBlobProviderScenario
implements PushOMDataSourceScenario {
    private final Blob blob = new RandomBlob(1024L);

    public void addTestParameters(MatrixTestCase testCase) {
        testCase.addTestParameter("scenario", "writeDataHandlerProvider");
    }

    @Override
    public Map<String, String> getNamespaceContext() {
        return Collections.emptyMap();
    }

    @Override
    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(null, "root", null);
        try {
            XMLStreamWriterUtils.writeBlob((XMLStreamWriter)writer, () -> this.blob, null, (boolean)true);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
        writer.writeEndElement();
    }

    @Override
    public void validate(OMElement element, boolean blobsPreserved) throws Throwable {
        OMText child = (OMText)element.getFirstOMChild();
        if (blobsPreserved) {
            Assert.assertTrue((boolean)child.isBinary());
            Assert.assertSame((Object)this.blob, (Object)child.getBlob());
        } else {
            child.setBinary(true);
            IOTestUtils.compareStreams((InputStream)this.blob.getInputStream(), (InputStream)child.getBlob().getInputStream());
        }
    }
}

