/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import com.google.common.truth.Truth;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.StringOMDataSource;
import org.apache.axiom.ts.AxiomTestCase;

public class TestStringOMDataSource
extends AxiomTestCase {
    public TestStringOMDataSource(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        String localName = "myPayload";
        String payload1 = "<tns:myPayload xmlns:tns=\"urn://test\">Payload One</tns:myPayload>";
        OMNamespace ns = factory.createOMNamespace("urn://test", "tns");
        StringOMDataSource somds = new StringOMDataSource(payload1);
        OMElement parent = factory.createOMElement("root", null);
        OMSourcedElement omse = factory.createOMElement((OMDataSource)somds, localName, ns);
        parent.addChild((OMNode)omse);
        OMNode firstChild = parent.getFirstOMChild();
        TestStringOMDataSource.assertTrue((String)"Expected OMSourcedElement child", (boolean)(firstChild instanceof OMSourcedElement));
        OMSourcedElement child = (OMSourcedElement)firstChild;
        TestStringOMDataSource.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        Truth.assertThat((Object)child.getDataSource()).isInstanceOf(StringOMDataSource.class);
        XMLStreamReader reader = child.getXMLStreamReader();
        reader.next();
        TestStringOMDataSource.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        StringWriter out = new StringWriter();
        parent.serialize((Writer)out);
        TestStringOMDataSource.assertTrue((String)"The payload was not present in the output", (out.toString().indexOf(payload1) > 0 ? 1 : 0) != 0);
        TestStringOMDataSource.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        StringOMDataSource ds = (StringOMDataSource)child.getDataSource();
        Truth.assertThat((String)ds.getObject()).isEqualTo((Object)payload1);
        ds.close();
        TestStringOMDataSource.assertTrue((String)"Close should free the resource", (ds.getObject() == null ? 1 : 0) != 0);
    }
}

