/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import com.google.common.truth.Truth;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.om.sourcedelement.util.PullOMDataSource;

public class TestSetDataSource
extends AxiomTestCase {
    public TestSetDataSource(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        String payload1 = "<tns:myPayload xmlns:tns=\"urn://test\">Payload One</tns:myPayload>";
        String payload2 = "<tns:myPayload xmlns:tns=\"urn://test\">Payload Two</tns:myPayload>";
        PullOMDataSource nonDestructiveOMDataSource1 = new PullOMDataSource(payload1, false);
        PullOMDataSource nonDestructiveOMDataSource2 = new PullOMDataSource(payload2, false);
        PullOMDataSource destructiveOMDataSource1 = new PullOMDataSource(payload1, true);
        PullOMDataSource destructiveOMDataSource2 = new PullOMDataSource(payload2, true);
        OMFactory factory = this.metaFactory.getOMFactory();
        OMElement parent = factory.createOMElement("parent", null);
        OMSourcedElement omse = factory.createOMElement((OMDataSource)nonDestructiveOMDataSource1, "myPayload", factory.createOMNamespace("urn://test", "tns"));
        parent.addChild((OMNode)omse);
        OMNode firstChild = parent.getFirstOMChild();
        TestSetDataSource.assertTrue((String)"Expected OMSourcedElement child", (boolean)(firstChild instanceof OMSourcedElement));
        OMSourcedElement child = (OMSourcedElement)firstChild;
        TestSetDataSource.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        Truth.assertThat((Object)child.getDataSource()).isSameInstanceAs((Object)nonDestructiveOMDataSource1);
        StringWriter sw = new StringWriter();
        parent.serialize((Writer)sw);
        String output = sw.toString();
        TestSetDataSource.assertTrue((String)"The payload was not present in the output", (output.indexOf(payload1) > 0 ? 1 : 0) != 0);
        TestSetDataSource.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        child.setDataSource((OMDataSource)nonDestructiveOMDataSource2);
        sw = new StringWriter();
        parent.serialize((Writer)sw);
        output = sw.toString();
        TestSetDataSource.assertTrue((String)"The payload was not present in the output", (output.indexOf(payload2) > 0 ? 1 : 0) != 0);
        TestSetDataSource.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        child.setDataSource((OMDataSource)destructiveOMDataSource1);
        sw = new StringWriter();
        parent.serialize((Writer)sw);
        output = sw.toString();
        TestSetDataSource.assertTrue((String)"The payload was not present in the output", (output.indexOf(payload1) > 0 ? 1 : 0) != 0);
        child.setDataSource((OMDataSource)destructiveOMDataSource2);
        sw = new StringWriter();
        parent.serialize((Writer)sw);
        output = sw.toString();
        TestSetDataSource.assertTrue((String)"The payload was not present in the output", (output.indexOf(payload2) > 0 ? 1 : 0) != 0);
    }
}

