/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.AbstractPushOMDataSource;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.om.sourcedelement.push.PushOMDataSourceScenario;

public class TestPushOMDataSourceExpansion
extends AxiomTestCase {
    private final PushOMDataSourceScenario scenario;

    public TestPushOMDataSourceExpansion(OMMetaFactory metaFactory, PushOMDataSourceScenario scenario) {
        super(metaFactory);
        this.scenario = scenario;
        scenario.addTestParameters(this);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        PushOMDataSource ds = new PushOMDataSource();
        OMSourcedElement element = factory.createOMElement((OMDataSource)ds);
        Iterator<Map.Entry<String, String>> it = this.scenario.getNamespaceContext().entrySet().iterator();
        if (it.hasNext()) {
            Map.Entry<String, String> binding = it.next();
            OMElement parent = factory.createOMElement("parent", factory.createOMNamespace(binding.getValue(), binding.getKey()));
            while (it.hasNext()) {
                binding = it.next();
                parent.declareNamespace(factory.createOMNamespace(binding.getValue(), binding.getKey()));
            }
            parent.addChild((OMNode)element);
        }
        this.scenario.validate((OMElement)element, true);
        TestPushOMDataSourceExpansion.assertTrue((String)"Invalid test case: validation didn't expand the OMSourcedElement", (boolean)ds.isExpanded());
    }

    class PushOMDataSource
    extends AbstractPushOMDataSource {
        private boolean expanded;

        PushOMDataSource() {
        }

        public void serialize(XMLStreamWriter writer) throws XMLStreamException {
            TestPushOMDataSourceExpansion.this.scenario.serialize(writer);
            this.expanded = true;
        }

        public boolean isDestructiveWrite() {
            return false;
        }

        boolean isExpanded() {
            return this.expanded;
        }
    }
}

