/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.om.sourcedelement.TestDocument;
import org.apache.axiom.ts.om.sourcedelement.util.PullOMDataSource;

public class TestName3Unqualified
extends AxiomTestCase {
    public TestName3Unqualified(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory f = this.metaFactory.getOMFactory();
        OMNamespace rootNS = f.createOMNamespace("http://sampleroot", "rootPrefix");
        OMNamespace ns = f.createOMNamespace("http://DUMMYNS", "DUMMYPREFIX");
        OMSourcedElement element = f.createOMElement((OMDataSource)new PullOMDataSource(TestDocument.DOCUMENT3.getContent()), "DUMMYNAME", ns);
        OMElement root = f.createOMElement("root", rootNS);
        root.addChild((OMNode)element);
        TestName3Unqualified.assertTrue((boolean)element.getLocalName().equals("DUMMYNAME"));
        TestName3Unqualified.assertTrue((boolean)element.getNamespace().getNamespaceURI().equals("http://DUMMYNS"));
        TestName3Unqualified.assertTrue((boolean)element.getNamespace().getPrefix().equals("DUMMYPREFIX"));
        StringWriter writer = new StringWriter();
        try {
            root.serialize((Writer)writer);
        }
        catch (Exception e) {
            return;
        }
        String result = writer.toString();
        TestName3Unqualified.assertTrue((boolean)element.getLocalName().equals("library"));
        TestName3Unqualified.assertTrue((boolean)element.getNamespace().getNamespaceURI().equals(""));
        TestName3Unqualified.assertTrue((boolean)element.getNamespace().getPrefix().equals(""));
        TestName3Unqualified.assertTrue((result.indexOf("DUMMY") < 0 ? 1 : 0) != 0);
        TestName3Unqualified.assertTrue((String)("Serialized text error" + result), (result.indexOf("1930110111") > 0 ? 1 : 0) != 0);
        writer = new StringWriter();
        root.serialize((Writer)writer);
        result = writer.toString();
        TestName3Unqualified.assertTrue((boolean)element.getLocalName().equals("library"));
        TestName3Unqualified.assertTrue((boolean)element.getNamespace().getNamespaceURI().equals("http://www.sosnoski.com/uwjws/library"));
        TestName3Unqualified.assertTrue((boolean)element.getNamespace().getPrefix().equals(""));
        TestName3Unqualified.assertTrue((result.indexOf("DUMMY") < 0 ? 1 : 0) != 0);
        TestName3Unqualified.assertTrue((String)("Serialized text error" + result), (result.indexOf("1930110111") > 0 ? 1 : 0) != 0);
    }
}

