/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.om.sourcedelement.TestDocument;
import org.apache.axiom.ts.om.sourcedelement.util.PullOMDataSource;

public class TestName2QualifiedPrefix
extends AxiomTestCase {
    public TestName2QualifiedPrefix(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory f = this.metaFactory.getOMFactory();
        OMNamespace rootNS = f.createOMNamespace("http://sampleroot", "rootPrefix");
        OMNamespace ns = f.createOMNamespace("http://www.sosnoski.com/uwjws/library", "");
        OMSourcedElement element = f.createOMElement((OMDataSource)new PullOMDataSource(TestDocument.DOCUMENT2.getContent()), "library", ns);
        OMElement root = f.createOMElement("root", rootNS);
        root.addChild((OMNode)element);
        TestName2QualifiedPrefix.assertTrue((boolean)element.getLocalName().equals("library"));
        TestName2QualifiedPrefix.assertTrue((boolean)element.getNamespace().getNamespaceURI().equals("http://www.sosnoski.com/uwjws/library"));
        TestName2QualifiedPrefix.assertTrue((boolean)element.getNamespace().getPrefix().equals(""));
        StringWriter writer = new StringWriter();
        root.serializeAndConsume((Writer)writer);
        String result = writer.toString();
        TestName2QualifiedPrefix.assertTrue((boolean)element.getLocalName().equals("library"));
        TestName2QualifiedPrefix.assertTrue((boolean)element.getNamespace().getNamespaceURI().equals("http://www.sosnoski.com/uwjws/library"));
        TestName2QualifiedPrefix.assertTrue((boolean)element.getNamespace().getPrefix().equals(""));
        TestName2QualifiedPrefix.assertTrue((result.indexOf("xmlns=") < 0 ? 1 : 0) != 0);
        TestName2QualifiedPrefix.assertTrue((String)("Serialized text error" + result), (result.indexOf("1930110111") > 0 ? 1 : 0) != 0);
    }
}

