/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.namespace.QName;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.WrappedTextNodeOMDataSourceFromBlob;
import org.apache.axiom.testutils.blob.RandomBlob;
import org.apache.axiom.testutils.io.IOTestUtils;
import org.apache.axiom.ts.AxiomTestCase;

public class TestGetTextAsStreamWithNonDestructiveOMDataSource
extends AxiomTestCase {
    public TestGetTextAsStreamWithNonDestructiveOMDataSource(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        RandomBlob blob = new RandomBlob(445566L, 32, 128, 20000000L);
        QName qname = new QName("a");
        Charset cs = StandardCharsets.US_ASCII;
        OMSourcedElement element = factory.createOMElement((OMDataSource)new WrappedTextNodeOMDataSourceFromBlob(qname, (Blob)blob, cs), qname);
        Reader in = element.getTextAsStream(true);
        TestGetTextAsStreamWithNonDestructiveOMDataSource.assertFalse((boolean)(in instanceof StringReader));
        IOTestUtils.compareStreams((Reader)new InputStreamReader(blob.getInputStream(), cs), (Reader)in);
        TestGetTextAsStreamWithNonDestructiveOMDataSource.assertFalse((boolean)element.isExpanded());
    }
}

