/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import com.google.common.truth.Truth;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.core.stream.sax.SAX;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.AbstractPushOMDataSource;
import org.apache.axiom.ts.AxiomTestCase;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TestGetSAXSourceWithPushOMDataSourceThrowingException
extends AxiomTestCase {
    public TestGetSAXSourceWithPushOMDataSourceThrowingException(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMSourcedElement element = this.metaFactory.getOMFactory().createOMElement((OMDataSource)new AbstractPushOMDataSource(){

            public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
                throw new XMLStreamException("TEST");
            }

            public boolean isDestructiveWrite() {
                return false;
            }
        });
        SAXSource saxSource = element.getSAXSource(true);
        XMLReader reader = saxSource.getXMLReader();
        reader.setContentHandler(SAX.createNullContentHandler());
        try {
            reader.parse(saxSource.getInputSource());
            TestGetSAXSourceWithPushOMDataSourceThrowingException.fail((String)"Expected SAXException");
        }
        catch (SAXException ex) {
            Throwable cause = ex.getCause();
            Truth.assertThat((Throwable)cause).isInstanceOf(XMLStreamException.class);
            Truth.assertThat((String)cause.getMessage()).isEqualTo((Object)"TEST");
        }
    }
}

