/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.ds.AbstractPushOMDataSource;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.om.sourcedelement.push.PushOMDataSourceScenario;

public class TestGetSAXSourceWithPushOMDataSource
extends AxiomTestCase {
    private final PushOMDataSourceScenario scenario;
    private boolean serializeParent;

    public TestGetSAXSourceWithPushOMDataSource(OMMetaFactory metaFactory, PushOMDataSourceScenario scenario, boolean serializeParent) {
        super(metaFactory);
        this.scenario = scenario;
        this.serializeParent = serializeParent;
        scenario.addTestParameters(this);
        this.addTestParameter("serializeParent", serializeParent);
    }

    protected void runTest() throws Throwable {
        OMElement parent;
        OMFactory factory = this.metaFactory.getOMFactory();
        OMSourcedElement sourcedElement = factory.createOMElement((OMDataSource)new AbstractPushOMDataSource(){

            public void serialize(XMLStreamWriter writer) throws XMLStreamException {
                TestGetSAXSourceWithPushOMDataSource.this.scenario.serialize(writer);
            }

            public boolean isDestructiveWrite() {
                return false;
            }
        });
        Iterator<Map.Entry<String, String>> it = this.scenario.getNamespaceContext().entrySet().iterator();
        if (it.hasNext()) {
            Map.Entry<String, String> binding = it.next();
            parent = factory.createOMElement("parent", factory.createOMNamespace(binding.getValue(), binding.getKey()));
            while (it.hasNext()) {
                binding = it.next();
                parent.declareNamespace(factory.createOMNamespace(binding.getValue(), binding.getKey()));
            }
        } else {
            parent = factory.createOMElement("parent", null);
        }
        parent.addChild((OMNode)sourcedElement);
        SAXSource saxSource = (this.serializeParent ? parent : sourcedElement).getSAXSource(true);
        OMElement element = OMXMLBuilderFactory.createOMBuilder((OMFactory)factory, (SAXSource)saxSource, (boolean)false).getDocumentElement();
        if (this.serializeParent) {
            element = element.getFirstElement();
        }
        this.scenario.validate(element, false);
    }
}

