/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import com.google.common.truth.Truth;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.dimension.ExpansionStrategy;
import org.apache.axiom.ts.om.sourcedelement.util.PullOMDataSource;

public class TestDiscard
extends AxiomTestCase {
    private final ExpansionStrategy expansionStrategy;

    public TestDiscard(OMMetaFactory metaFactory, ExpansionStrategy expansionStrategy) {
        super(metaFactory);
        this.expansionStrategy = expansionStrategy;
        expansionStrategy.addTestParameters(this);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMElement parent = factory.createOMElement("parent", null);
        OMElement child1 = factory.createOMElement("child1", null, (OMContainer)parent);
        PullOMDataSource ds = new PullOMDataSource("<root><a/><b/></root>");
        OMSourcedElement omse = factory.createOMElement((OMDataSource)ds, "root", null);
        parent.addChild((OMNode)omse);
        OMElement child2 = factory.createOMElement("child2", null, (OMContainer)parent);
        this.expansionStrategy.apply((OMContainer)omse);
        omse.discard();
        Truth.assertThat((Object)child1.getNextOMSibling()).isSameInstanceAs((Object)child2);
        Truth.assertThat((Boolean)ds.hasUnclosedReaders()).isFalse();
        Truth.assertThat((Integer)ds.getReaderRequestCount()).isEqualTo((Object)(this.expansionStrategy == ExpansionStrategy.DONT_EXPAND ? 0 : 1));
    }
}

