/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import java.io.Reader;
import java.io.StringReader;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.dimension.ExpansionStrategy;
import org.apache.axiom.ts.om.sourcedelement.util.PullOMDataSource;

public class TestDetach
extends AxiomTestCase {
    private final ExpansionStrategy expansionStrategy;

    public TestDetach(OMMetaFactory metaFactory, ExpansionStrategy expansionStrategy) {
        super(metaFactory);
        this.expansionStrategy = expansionStrategy;
        expansionStrategy.addTestParameters(this);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        String xml1 = "<root><a/><b/></root>";
        String xml2 = "<child><c/><d/></child>";
        OMElement parent = OMXMLBuilderFactory.createOMBuilder((OMFactory)factory, (Reader)new StringReader(xml1)).getDocumentElement();
        PullOMDataSource ds = new PullOMDataSource(xml2);
        OMSourcedElement omse = factory.createOMElement((OMDataSource)ds, "child", null);
        parent.getFirstOMChild().insertSiblingBefore((OMNode)omse);
        this.expansionStrategy.apply((OMContainer)omse);
        omse.detach();
        Truth.assertThat((Boolean)ds.hasUnclosedReaders()).isEqualTo((Object)(this.expansionStrategy == ExpansionStrategy.PARTIAL ? 1 : 0));
        Truth.assertThat((Integer)ds.getReaderRequestCount()).isEqualTo((Object)(this.expansionStrategy == ExpansionStrategy.DONT_EXPAND ? 0 : 1));
        ((XMLSubject)Truth.assertAbout((Subject.Factory)XMLTruth.xml()).that(XMLTruth.xml(OMElement.class, (Object)parent))).hasSameContentAs((Object)xml1);
        ((XMLSubject)Truth.assertAbout((Subject.Factory)XMLTruth.xml()).that(XMLTruth.xml(OMElement.class, (Object)omse))).hasSameContentAs((Object)xml2);
    }
}

