/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import com.google.common.truth.Truth;
import java.util.Iterator;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.om.sourcedelement.util.PullOMDataSource;

public class TestDeclareNamespace
extends AxiomTestCase {
    public TestDeclareNamespace(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMSourcedElement element = factory.createOMElement((OMDataSource)new PullOMDataSource("<root xmlns:p='urn:ns1'><child/></root>"), "root", null);
        element.declareNamespace("urn:ns2", "p");
        Truth.assertThat((Object)element.getFirstOMChild()).isNotNull();
        OMNamespace ns = element.findNamespaceURI("p");
        Truth.assertThat((Object)ns).isNotNull();
        Truth.assertThat((String)ns.getPrefix()).isEqualTo((Object)"p");
        Truth.assertThat((String)ns.getNamespaceURI()).isEqualTo((Object)"urn:ns2");
        Iterator it = element.getAllDeclaredNamespaces();
        Truth.assertThat((Boolean)it.hasNext()).isTrue();
        Truth.assertThat(it.next()).isSameInstanceAs((Object)ns);
        Truth.assertThat((Boolean)it.hasNext()).isFalse();
    }
}

