/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import java.nio.charset.StandardCharsets;
import javax.xml.namespace.QName;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.WrappedTextNodeOMDataSourceFromBlob;
import org.apache.axiom.testutils.blob.TextBlob;
import org.apache.axiom.ts.AxiomTestCase;

public class TestCloneNonDestructive
extends AxiomTestCase {
    private final boolean copyOMDataSources;

    public TestCloneNonDestructive(OMMetaFactory metaFactory, boolean copyOMDataSources) {
        super(metaFactory);
        this.copyOMDataSources = copyOMDataSources;
        this.addTestParameter("copyOMDataSources", copyOMDataSources);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        WrappedTextNodeOMDataSourceFromBlob ds = new WrappedTextNodeOMDataSourceFromBlob(new QName("wrapper"), (Blob)new TextBlob("test", StandardCharsets.UTF_8), StandardCharsets.UTF_8);
        OMSourcedElement element = factory.createOMElement((OMDataSource)ds);
        OMCloneOptions options = new OMCloneOptions();
        options.setCopyOMDataSources(this.copyOMDataSources);
        OMElement clone = (OMElement)element.clone(options);
        if (this.copyOMDataSources) {
            TestCloneNonDestructive.assertTrue((boolean)(clone instanceof OMSourcedElement));
            TestCloneNonDestructive.assertFalse((boolean)element.isExpanded());
        } else {
            TestCloneNonDestructive.assertFalse((boolean)(clone instanceof OMSourcedElement));
            TestCloneNonDestructive.assertTrue((boolean)clone.isComplete());
        }
        TestCloneNonDestructive.assertEquals((String)"test", (String)clone.getText());
        TestCloneNonDestructive.assertEquals((String)"wrapper", (String)clone.getLocalName());
    }
}

