/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import com.google.common.truth.Truth;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.blob.Blobs;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.BlobOMDataSource;
import org.apache.axiom.ts.AxiomTestCase;

public class TestBlobOMDataSource
extends AxiomTestCase {
    public TestBlobOMDataSource(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        String localName = "myPayload";
        String encoding = "utf-8";
        String payload = "<tns:myPayload xmlns:tns=\"urn://test\">Payload One</tns:myPayload>";
        OMNamespace ns = factory.createOMNamespace("urn://test", "tns");
        BlobOMDataSource ds = new BlobOMDataSource(Blobs.createBlob((byte[])payload.getBytes(encoding)), encoding);
        OMElement parent = factory.createOMElement("root", null);
        OMSourcedElement omse = factory.createOMElement((OMDataSource)ds, localName, ns);
        parent.addChild((OMNode)omse);
        OMNode firstChild = parent.getFirstOMChild();
        TestBlobOMDataSource.assertTrue((String)"Expected OMSourcedElement child", (boolean)(firstChild instanceof OMSourcedElement));
        OMSourcedElement child = (OMSourcedElement)firstChild;
        TestBlobOMDataSource.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        Truth.assertThat((Object)child.getDataSource()).isSameInstanceAs((Object)ds);
        XMLStreamReader reader = child.getXMLStreamReader();
        reader.next();
        TestBlobOMDataSource.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        TestBlobOMDataSource.assertTrue((String)"The payload was not present in the output", (parent.toString().indexOf(payload) > 0 ? 1 : 0) != 0);
        TestBlobOMDataSource.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        parent.build();
        TestBlobOMDataSource.assertTrue((String)"OMSourcedElement is expanded after build().  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        parent.buildWithAttachments();
        TestBlobOMDataSource.assertTrue((String)"OMSourcedElement is expanded after buildWithAttachments().  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        Truth.assertThat((Object)child.getDataSource()).isSameInstanceAs((Object)ds);
    }
}

