/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import com.google.common.truth.Truth;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.dimension.AddAttributeStrategy;
import org.apache.axiom.ts.om.sourcedelement.util.PullOMDataSource;

public class TestAddAttribute
extends AxiomTestCase {
    private final AddAttributeStrategy strategy;

    public TestAddAttribute(OMMetaFactory metaFactory, AddAttributeStrategy strategy) {
        super(metaFactory);
        this.strategy = strategy;
        strategy.addTestParameters(this);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMSourcedElement element = factory.createOMElement((OMDataSource)new PullOMDataSource("<root attr='orgvalue'><child/></root>"), "root", null);
        OMAttribute attr = this.strategy.addAttribute((OMElement)element, "attr", null, "newvalue");
        Truth.assertThat((Object)element.getFirstOMChild()).isNotNull();
        OMAttribute attr2 = element.getAttribute(new QName("attr"));
        Truth.assertThat((Object)attr2).isSameInstanceAs((Object)attr);
        Truth.assertThat((String)attr2.getAttributeValue()).isEqualTo((Object)"newvalue");
        Iterator it = element.getAllAttributes();
        Truth.assertThat((Boolean)it.hasNext()).isTrue();
        Truth.assertThat(it.next()).isSameInstanceAs((Object)attr);
        Truth.assertThat((Boolean)it.hasNext()).isFalse();
    }
}

