/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.WrappedTextNodeOMDataSourceFromReader;
import org.apache.axiom.testutils.suite.MatrixTestCase;
import org.apache.axiom.ts.om.sourcedelement.util.PullOMDataSource;

public abstract class OMSourcedElementVariant {
    public static final OMSourcedElementVariant[] INSTANCES = new OMSourcedElementVariant[]{new OMSourcedElementVariant("qname-aware-source", false, false, false){

        @Override
        public OMSourcedElement createOMSourcedElement(OMFactory factory, QName qname) throws Exception {
            return factory.createOMElement((OMDataSource)new WrappedTextNodeOMDataSourceFromReader(qname, (Reader)new StringReader("test")));
        }
    }, new OMSourcedElementVariant("unknown-name", true, true, true){

        @Override
        public OMSourcedElement createOMSourcedElement(OMFactory factory, QName qname) throws Exception {
            OMElement orgElement = factory.createOMElement(qname.getLocalPart(), qname.getNamespaceURI(), qname.getPrefix());
            return factory.createOMElement((OMDataSource)new PullOMDataSource(orgElement.toString()));
        }
    }, new OMSourcedElementVariant("unknown-prefix", false, false, true){

        @Override
        public OMSourcedElement createOMSourcedElement(OMFactory factory, QName qname) throws Exception {
            OMElement orgElement = factory.createOMElement(qname.getLocalPart(), qname.getNamespaceURI(), qname.getPrefix());
            return factory.createOMElement((OMDataSource)new PullOMDataSource(orgElement.toString()), qname.getLocalPart(), factory.createOMNamespace(qname.getNamespaceURI(), null));
        }
    }};
    private final String name;
    private final boolean localNameRequiresExpansion;
    private final boolean namespaceURIRequiresExpansion;
    private final boolean prefixRequiresExpansion;

    public OMSourcedElementVariant(String name, boolean localNameRequiresExpansion, boolean namespaceURIRequiresExpansion, boolean prefixRequiresExpansion) {
        this.name = name;
        this.localNameRequiresExpansion = localNameRequiresExpansion;
        this.namespaceURIRequiresExpansion = namespaceURIRequiresExpansion;
        this.prefixRequiresExpansion = prefixRequiresExpansion;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLocalNameRequiresExpansion() {
        return this.localNameRequiresExpansion;
    }

    public boolean isNamespaceURIRequiresExpansion() {
        return this.namespaceURIRequiresExpansion;
    }

    public boolean isPrefixRequiresExpansion(QName qname) {
        return this.prefixRequiresExpansion && (this.namespaceURIRequiresExpansion || qname.getNamespaceURI().length() != 0);
    }

    public void addTestProperties(MatrixTestCase test) {
    }

    public abstract OMSourcedElement createOMSourcedElement(OMFactory var1, QName var2) throws Exception;
}

