/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.factory;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.ext.stax.BlobProvider;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMText;
import org.apache.axiom.testutils.blob.TextBlob;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.util.UIDGenerator;
import org.assertj.core.api.Assertions;

public class TestCreateOMTextFromBlobProvider
extends AxiomTestCase {
    private final boolean nullContentID;

    public TestCreateOMTextFromBlobProvider(OMMetaFactory metaFactory, boolean nullContentID) {
        super(metaFactory);
        this.nullContentID = nullContentID;
        this.addTestParameter("nullContentId", nullContentID);
    }

    protected void runTest() throws Throwable {
        TestBlobProvider prov = new TestBlobProvider();
        OMFactory factory = this.metaFactory.getOMFactory();
        String contentID = this.nullContentID ? null : UIDGenerator.generateContentId();
        OMText text = factory.createOMText(contentID, (BlobProvider)prov, true);
        TestCreateOMTextFromBlobProvider.assertFalse((boolean)prov.isBlobCreated());
        Assertions.assertThat((InputStream)text.getBlob().getInputStream()).asString(StandardCharsets.UTF_8).isEqualTo("Data");
        TestCreateOMTextFromBlobProvider.assertTrue((boolean)prov.isBlobCreated());
        if (contentID == null) {
            Assertions.assertThat((String)text.getContentID()).isNotNull();
        } else {
            Assertions.assertThat((String)text.getContentID()).isEqualTo(contentID);
        }
    }

    static class TestBlobProvider
    implements BlobProvider {
        private Blob blob;

        TestBlobProvider() {
        }

        public Blob getBlob() {
            if (this.blob == null) {
                this.blob = new TextBlob("Data", StandardCharsets.UTF_8);
            }
            return this.blob;
        }

        public boolean isBlobCreated() {
            return this.blob != null;
        }
    }
}

