/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element.sr;

import java.io.StringReader;
import java.util.Iterator;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.dimension.BuilderFactory;
import org.xml.sax.InputSource;

public class TestGetElementTextFromParser
extends AxiomTestCase {
    private final BuilderFactory builderFactory;
    private final boolean cache;
    private final int build;

    public TestGetElementTextFromParser(OMMetaFactory metaFactory, BuilderFactory builderFactory, boolean cache, int build) {
        super(metaFactory);
        this.builderFactory = builderFactory;
        this.cache = cache;
        this.build = build;
        builderFactory.addTestParameters(this);
        this.addTestParameter("cache", cache);
        this.addTestParameter("build", build);
    }

    protected void runTest() throws Throwable {
        OMXMLParserWrapper builder = this.builderFactory.getBuilder(this.metaFactory, new InputSource(new StringReader("<a><b>AB<!--comment text-->CD</b></a>")));
        OMElement element = builder.getDocumentElement();
        Iterator it = element.getDescendants(true);
        for (int i = 0; i < this.build; ++i) {
            it.next();
        }
        XMLStreamReader reader = element.getXMLStreamReader(this.cache);
        TestGetElementTextFromParser.assertEquals((int)1, (int)reader.next());
        TestGetElementTextFromParser.assertEquals((int)1, (int)reader.next());
        TestGetElementTextFromParser.assertEquals((String)"ABCD", (String)reader.getElementText());
    }
}

