/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element.sr;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.testutils.blob.RandomBlob;
import org.apache.axiom.testutils.io.IOTestUtils;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.util.stax.XMLStreamReaderUtils;

public class TestGetBlobFromElement
extends AxiomTestCase {
    private final boolean cache;

    public TestGetBlobFromElement(OMMetaFactory metaFactory, boolean cache) {
        super(metaFactory);
        this.cache = cache;
        this.addTestParameter("cache", cache);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        RandomBlob orgBlob = new RandomBlob(65536L);
        OMElement orgRoot = factory.createOMElement(new QName("root"));
        OMElement orgChild = factory.createOMElement(new QName("child"), (OMContainer)orgRoot);
        orgChild.addChild((OMNode)factory.createOMText((Blob)orgBlob, false));
        OMElement root = OMXMLBuilderFactory.createOMBuilder((OMFactory)factory, (Reader)new StringReader(orgRoot.toString())).getDocumentElement();
        XMLStreamReader reader = root.getXMLStreamReader(this.cache);
        TestGetBlobFromElement.assertEquals((int)1, (int)reader.next());
        TestGetBlobFromElement.assertEquals((int)1, (int)reader.next());
        Blob blob = XMLStreamReaderUtils.getBlobFromElement((XMLStreamReader)reader);
        IOTestUtils.compareStreams((InputStream)orgBlob.getInputStream(), (InputStream)blob.getInputStream());
    }
}

