/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element.sr;

import java.io.StringReader;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.dimension.BuilderFactory;
import org.xml.sax.InputSource;

public class TestCommentEvent
extends AxiomTestCase {
    private final BuilderFactory builderFactory;
    private final boolean cache;

    public TestCommentEvent(OMMetaFactory metaFactory, BuilderFactory builderFactory, boolean cache) {
        super(metaFactory);
        this.builderFactory = builderFactory;
        this.cache = cache;
        builderFactory.addTestParameters(this);
        this.addTestParameter("cache", cache);
    }

    protected void runTest() throws Throwable {
        OMXMLParserWrapper builder = this.builderFactory.getBuilder(this.metaFactory, new InputSource(new StringReader("<a><!--comment text--></a>")));
        OMElement element = builder.getDocumentElement();
        XMLStreamReader reader = element.getXMLStreamReader(this.cache);
        TestCommentEvent.assertEquals((int)1, (int)reader.next());
        TestCommentEvent.assertEquals((int)5, (int)reader.next());
        TestCommentEvent.assertEquals((String)"comment text", (String)reader.getText());
        TestCommentEvent.assertEquals((String)"comment text", (String)new String(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength()));
        StringBuffer text = new StringBuffer();
        char[] buf = new char[5];
        int sourceStart = 0;
        while (true) {
            int nCopied = reader.getTextCharacters(sourceStart, buf, 0, buf.length);
            text.append(buf, 0, nCopied);
            if (nCopied < buf.length) break;
            sourceStart += buf.length;
        }
        TestCommentEvent.assertEquals((String)"comment text", (String)text.toString());
        element.close(false);
    }
}

