/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.ts.AxiomTestCase;

public class TestSerialization
extends AxiomTestCase {
    private static final String NS = "urn:ns";
    private static final String PREFIX = "p";
    private final String parent;
    private final String children;
    private final String expected;

    public TestSerialization(OMMetaFactory metaFactory, String parent, String children, String expected) {
        super(metaFactory);
        this.parent = parent;
        this.children = children;
        this.expected = expected;
        this.addTestParameter("parent", parent);
        this.addTestParameter("children", children);
    }

    private static OMNamespace createNamespace(OMFactory factory, String type) {
        if (type.equals("Q")) {
            return factory.createOMNamespace(NS, PREFIX);
        }
        if (type.equals("U")) {
            return factory.createOMNamespace("", "");
        }
        if (type.equals("D")) {
            return factory.createOMNamespace(NS, "");
        }
        throw new IllegalArgumentException();
    }

    protected void runTest() throws Throwable {
        OMFactory fac = this.metaFactory.getOMFactory();
        OMNamespace nsParent = TestSerialization.createNamespace(fac, this.parent);
        OMNamespace nsChildren = TestSerialization.createNamespace(fac, this.children);
        OMElement personElem = fac.createOMElement("person", nsParent);
        OMElement nameElem = fac.createOMElement("name", nsChildren);
        nameElem.setText("John");
        OMElement ageElem = fac.createOMElement("age", nsChildren);
        ageElem.setText("34");
        OMElement weightElem = fac.createOMElement("weight", nsChildren);
        weightElem.setText("50");
        personElem.addChild((OMNode)nameElem);
        personElem.addChild((OMNode)ageElem);
        personElem.addChild((OMNode)weightElem);
        TestSerialization.assertEquals((String)this.expected, (String)personElem.toString());
    }
}

