/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import com.google.common.truth.Truth;
import java.io.InputStream;
import java.util.HashSet;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLStreamReaderConfiguration;
import org.apache.axiom.ts.AxiomTestCase;

public class TestGetXMLStreamReaderWithPreserveNamespaceContext
extends AxiomTestCase {
    private final boolean preserveNamespaceContext;
    private final boolean cache;

    public TestGetXMLStreamReaderWithPreserveNamespaceContext(OMMetaFactory metaFactory, boolean preserveNamespaceContext, boolean cache) {
        super(metaFactory);
        this.preserveNamespaceContext = preserveNamespaceContext;
        this.addTestParameter("preserveNamespaceContext", preserveNamespaceContext);
        this.cache = cache;
        this.addTestParameter("cache", cache);
    }

    protected void runTest() throws Throwable {
        InputStream in = TestGetXMLStreamReaderWithPreserveNamespaceContext.class.getResourceAsStream("AXIOM-114.xml");
        OMElement root = OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (InputStream)in).getDocumentElement();
        root.declareNamespace("http://example.org", "p");
        OMXMLStreamReaderConfiguration configuration = new OMXMLStreamReaderConfiguration();
        configuration.setPreserveNamespaceContext(this.preserveNamespaceContext);
        XMLStreamReader reader = root.getFirstElement().getFirstElement().getXMLStreamReader(this.cache, configuration);
        Truth.assertThat((Integer)reader.next()).isEqualTo((Object)1);
        HashSet<String> prefixes = new HashSet<String>();
        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
            prefixes.add(reader.getNamespacePrefix(i));
        }
        if (this.preserveNamespaceContext) {
            Truth.assertThat(prefixes).containsExactly(new Object[]{"soapenv", "xsd", "xsi", "ns", "p"});
        } else {
            Truth.assertThat(prefixes).containsExactly(new Object[]{"ns"});
        }
        reader.nextTag();
        Truth.assertThat((String)reader.getNamespaceURI("xsd")).isEqualTo((Object)"http://www.w3.org/2001/XMLSchema");
        Truth.assertThat((String)reader.getNamespaceURI("p")).isEqualTo((Object)"http://example.org");
        NamespaceContext nc = reader.getNamespaceContext();
        Truth.assertThat((String)nc.getPrefix("http://www.w3.org/2001/XMLSchema")).isEqualTo((Object)"xsd");
        Truth.assertThat((String)nc.getPrefix("http://example.org")).isEqualTo((Object)"p");
    }
}

