/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.ts.AxiomTestCase;

public class TestGetXMLStreamReaderOnNonRootElement
extends AxiomTestCase {
    private final boolean cache;

    public TestGetXMLStreamReaderOnNonRootElement(OMMetaFactory metaFactory, boolean cache) {
        super(metaFactory);
        this.cache = cache;
        this.addTestParameter("cache", cache);
    }

    protected void runTest() throws Throwable {
        OMElement root = AXIOMUtil.stringToOM((OMFactory)this.metaFactory.getOMFactory(), (String)"<a><b><c/></b><d>content</d></a>");
        OMElement b = (OMElement)root.getFirstOMChild();
        XMLStreamReader stream = b.getXMLStreamReader(this.cache);
        TestGetXMLStreamReaderOnNonRootElement.assertEquals((int)7, (int)stream.getEventType());
        TestGetXMLStreamReaderOnNonRootElement.assertEquals((int)1, (int)stream.next());
        TestGetXMLStreamReaderOnNonRootElement.assertEquals((String)"b", (String)stream.getLocalName());
        TestGetXMLStreamReaderOnNonRootElement.assertEquals((int)1, (int)stream.next());
        TestGetXMLStreamReaderOnNonRootElement.assertEquals((String)"c", (String)stream.getLocalName());
        TestGetXMLStreamReaderOnNonRootElement.assertEquals((int)2, (int)stream.next());
        TestGetXMLStreamReaderOnNonRootElement.assertEquals((int)2, (int)stream.next());
        TestGetXMLStreamReaderOnNonRootElement.assertEquals((int)8, (int)stream.next());
        OMElement d = (OMElement)b.getNextOMSibling();
        TestGetXMLStreamReaderOnNonRootElement.assertEquals((String)"content", (String)d.getText());
        root.close(false);
    }
}

