/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.ts.AxiomTestCase;

public class TestGetXMLStreamReaderCDATAEventFromParser
extends AxiomTestCase {
    public TestGetXMLStreamReaderCDATAEventFromParser(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        ByteArrayInputStream is = new ByteArrayInputStream("<test><![CDATA[hello world]]></test>".getBytes());
        XMLStreamReader reader = StAXUtils.createXMLStreamReader((StAXParserConfiguration)StAXParserConfiguration.NON_COALESCING, (InputStream)is);
        OMElement element = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (XMLStreamReader)reader).getDocumentElement();
        element.build();
        XMLStreamReader reader2 = element.getXMLStreamReader();
        int event = reader2.next();
        TestGetXMLStreamReaderCDATAEventFromParser.assertEquals((int)1, (int)event);
        while (reader2.hasNext() && event != 12) {
            event = reader2.next();
        }
        if (reader.toString().indexOf("wstx") != -1) {
            TestGetXMLStreamReaderCDATAEventFromParser.assertEquals((int)12, (int)event);
            TestGetXMLStreamReaderCDATAEventFromParser.assertEquals((String)"hello world", (String)reader2.getText());
            TestGetXMLStreamReaderCDATAEventFromParser.assertTrue((boolean)Arrays.equals("hello world".toCharArray(), reader2.getTextCharacters()));
            TestGetXMLStreamReaderCDATAEventFromParser.assertEquals((int)2, (int)reader2.next());
        }
    }
}

