/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.testutils.blob.RandomBlob;
import org.apache.axiom.testutils.io.IOTestUtils;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.commons.codec.binary.Base64;

public class TestGetTextBinary
extends AxiomTestCase {
    private final boolean compact;

    public TestGetTextBinary(OMMetaFactory metaFactory, boolean compact) {
        super(metaFactory);
        this.compact = compact;
        this.addTestParameter("compact", compact);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        RandomBlob blob = new RandomBlob(99999L, 1000L);
        OMElement element = factory.createOMElement("elem", null);
        element.addChild((OMNode)factory.createOMText((Blob)blob, false));
        if (this.compact) {
            element = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)factory, (XMLStreamReader)element.getXMLStreamReader()).getDocumentElement();
            element.build();
        }
        IOTestUtils.compareStreams((InputStream)blob.getInputStream(), (InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)element.getText())));
    }
}

