/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import java.io.InputStream;
import javax.xml.transform.Transformer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.jaxp.xslt.XSLTImplementation;

public class TestGetSAXSourceIdentityTransformOnFragment
extends AxiomTestCase {
    private final XSLTImplementation xsltImplementation;
    private final boolean cache;

    public TestGetSAXSourceIdentityTransformOnFragment(OMMetaFactory metaFactory, XSLTImplementation xsltImplementation, boolean cache) {
        super(metaFactory);
        this.xsltImplementation = xsltImplementation;
        this.cache = cache;
        this.addTestParameter("xslt", xsltImplementation.getName());
        this.addTestParameter("cache", cache);
    }

    private InputStream getInput() {
        return TestGetSAXSourceIdentityTransformOnFragment.class.getResourceAsStream("test.xml");
    }

    protected void runTest() throws Throwable {
        Transformer transformer = this.xsltImplementation.newTransformerFactory().newTransformer();
        OMFactory factory = this.metaFactory.getOMFactory();
        OMElement element = OMXMLBuilderFactory.createOMBuilder((OMFactory)factory, (InputStream)this.getInput()).getDocumentElement().getFirstElement();
        OMDocument outputDocument = factory.createOMDocument();
        transformer.transform(element.getSAXSource(this.cache), outputDocument.getSAXResult());
        OMNamespace ns = outputDocument.getOMDocumentElement().findNamespaceURI("p");
        TestGetSAXSourceIdentityTransformOnFragment.assertNotNull((Object)ns);
        TestGetSAXSourceIdentityTransformOnFragment.assertEquals((String)"urn:some:namespace", (String)ns.getNamespaceURI());
        element.close(false);
    }
}

