/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.ts.AxiomTestCase;

public class TestGetFirstChildWithName
extends AxiomTestCase {
    public TestGetFirstChildWithName(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMNamespace ns1 = factory.createOMNamespace("urn:ns1", "ns1");
        OMNamespace ns2 = factory.createOMNamespace("urn:ns2", "ns2");
        OMElement parent = factory.createOMElement("root", null);
        OMElement child1 = factory.createOMElement("a", ns1, (OMContainer)parent);
        factory.createOMComment((OMContainer)parent, "some comment");
        OMElement child2 = factory.createOMElement("b", ns2, (OMContainer)parent);
        OMElement child3 = factory.createOMElement("b", ns1, (OMContainer)parent);
        OMElement child4 = factory.createOMElement("c", null, (OMContainer)parent);
        factory.createOMElement("a", ns1, (OMContainer)parent);
        TestGetFirstChildWithName.assertSame((Object)child1, (Object)parent.getFirstChildWithName(new QName("urn:ns1", "a")));
        TestGetFirstChildWithName.assertSame((Object)child2, (Object)parent.getFirstChildWithName(new QName("urn:ns2", "b")));
        TestGetFirstChildWithName.assertNull((Object)parent.getFirstChildWithName(new QName("b")));
        TestGetFirstChildWithName.assertSame((Object)child3, (Object)parent.getFirstChildWithName(new QName("urn:ns1", "b", "ns2")));
        TestGetFirstChildWithName.assertSame((Object)child4, (Object)parent.getFirstChildWithName(new QName("c")));
    }
}

