/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import com.google.common.truth.Truth;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.ts.AxiomTestCase;

public class TestGetChildrenWithName4
extends AxiomTestCase {
    private static final String NS_A = "urn://a";
    private static final String NS_B = "urn://b";
    private static final String NS_C = "urn://c";

    public TestGetChildrenWithName4(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMNamespace a = factory.createOMNamespace(NS_A, "a");
        OMNamespace b = factory.createOMNamespace(NS_B, "b");
        OMElement documentElement = factory.createOMElement("Document", a);
        factory.createOMElement("sample", a, (OMContainer)documentElement);
        factory.createOMElement("sample", b, (OMContainer)documentElement);
        QName qName = new QName(NS_A, "sample");
        Truth.assertThat((Integer)TestGetChildrenWithName4.getChildrenCount(documentElement.getChildrenWithName(qName))).isEqualTo((Object)1);
        qName = new QName(NS_B, "sample");
        Truth.assertThat((Integer)TestGetChildrenWithName4.getChildrenCount(documentElement.getChildrenWithName(qName))).isEqualTo((Object)1);
        qName = new QName(NS_C, "sample");
        Truth.assertThat((Integer)TestGetChildrenWithName4.getChildrenCount(documentElement.getChildrenWithName(qName))).isEqualTo((Object)0);
        qName = new QName("", "sample");
        Truth.assertThat((Integer)TestGetChildrenWithName4.getChildrenCount(documentElement.getChildrenWithName(qName))).isEqualTo((Object)0);
        factory.createOMElement("sample", null, (OMContainer)documentElement);
        qName = new QName(NS_A, "sample");
        Truth.assertThat((Integer)TestGetChildrenWithName4.getChildrenCount(documentElement.getChildrenWithName(qName))).isEqualTo((Object)1);
        qName = new QName(NS_B, "sample");
        Truth.assertThat((Integer)TestGetChildrenWithName4.getChildrenCount(documentElement.getChildrenWithName(qName))).isEqualTo((Object)1);
        qName = new QName(NS_C, "sample");
        Truth.assertThat((Integer)TestGetChildrenWithName4.getChildrenCount(documentElement.getChildrenWithName(qName))).isEqualTo((Object)0);
        qName = new QName("", "sample");
        Truth.assertThat((Integer)TestGetChildrenWithName4.getChildrenCount(documentElement.getChildrenWithName(qName))).isEqualTo((Object)1);
    }
}

