/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.ts.AxiomTestCase;

public class TestAddAttributeGeneratedPrefix
extends AxiomTestCase {
    private final boolean defaultNamespaceInScope;

    public TestAddAttributeGeneratedPrefix(OMMetaFactory metaFactory, boolean defaultNamespaceInScope) {
        super(metaFactory);
        this.defaultNamespaceInScope = defaultNamespaceInScope;
        this.addTestParameter("defaultNamespaceInScope", defaultNamespaceInScope);
    }

    protected void runTest() throws Throwable {
        OMElement element;
        OMAttribute attr;
        OMNamespace ns;
        OMFactory factory = this.metaFactory.getOMFactory();
        OMNamespace otherNS = factory.createOMNamespace("urn:ns2", "p");
        OMElement parent = factory.createOMElement("parent", otherNS);
        if (this.defaultNamespaceInScope) {
            parent.declareDefaultNamespace("urn:test");
        }
        TestAddAttributeGeneratedPrefix.assertTrue(((ns = (attr = (element = factory.createOMElement("test", otherNS, (OMContainer)parent)).addAttribute("attr", "value", factory.createOMNamespace("urn:test", null))).getNamespace()).getPrefix().length() > 0 ? 1 : 0) != 0);
        Iterator it = element.getAllDeclaredNamespaces();
        TestAddAttributeGeneratedPrefix.assertTrue((boolean)it.hasNext());
        TestAddAttributeGeneratedPrefix.assertEquals((Object)ns, it.next());
        TestAddAttributeGeneratedPrefix.assertFalse((boolean)it.hasNext());
    }
}

