/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.document.sr;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.ext.stax.CharacterDataReader;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.ts.AxiomTestCase;

public class TestCharacterDataReaderFromParser
extends AxiomTestCase {
    private final boolean cache;

    public TestCharacterDataReaderFromParser(OMMetaFactory metaFactory, boolean cache) {
        super(metaFactory);
        this.cache = cache;
        this.addTestParameter("cache", cache);
    }

    protected void runTest() throws Throwable {
        String text = "This is a test for the CharacterDataReader extension";
        OMDocument doc = OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (Reader)new StringReader("<root>" + text + "</root>")).getDocument();
        XMLStreamReader reader = doc.getXMLStreamReader(this.cache);
        CharacterDataReader cdataReader = (CharacterDataReader)reader.getProperty(CharacterDataReader.PROPERTY);
        TestCharacterDataReaderFromParser.assertNotNull((Object)cdataReader);
        TestCharacterDataReaderFromParser.assertEquals((int)1, (int)reader.next());
        StringWriter sw = new StringWriter();
        while (reader.next() == 4) {
            cdataReader.writeTextTo((Writer)sw);
        }
        TestCharacterDataReaderFromParser.assertEquals((String)text, (String)sw.toString());
    }
}

