/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.cross;

import com.google.common.truth.Truth;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.ts.om.cross.CrossOMTestCase;

public class TestInsertSibling
extends CrossOMTestCase {
    private final boolean before;

    public TestInsertSibling(OMMetaFactory metaFactory, OMMetaFactory altMetaFactory, boolean before) {
        super(metaFactory, altMetaFactory);
        this.before = before;
        this.addTestParameter("before", before);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMElement parent = factory.createOMElement("parent", null);
        OMText child = factory.createOMText((OMContainer)parent, "test");
        OMComment orgSibling = this.altMetaFactory.getOMFactory().createOMComment(null, "test");
        if (this.before) {
            child.insertSiblingBefore((OMNode)orgSibling);
        } else {
            child.insertSiblingAfter((OMNode)orgSibling);
        }
        OMComment sibling = (OMComment)(this.before ? child.getPreviousOMSibling() : child.getNextOMSibling());
        Truth.assertThat((Object)sibling).isNotSameInstanceAs((Object)orgSibling);
        Truth.assertThat((String)sibling.getValue()).isEqualTo((Object)"test");
    }
}

