/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.container;

import java.io.InputStream;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.testutils.stax.XMLStreamReaderComparator;
import org.apache.axiom.ts.ConformanceTestCase;
import org.apache.axiom.ts.dimension.BuilderFactory;
import org.apache.axiom.ts.om.container.OMContainerExtractor;
import org.apache.axiom.ts.xml.XMLSample;
import org.xml.sax.InputSource;

public class TestGetXMLStreamReader
extends ConformanceTestCase {
    private final BuilderFactory builderFactory;
    private final OMContainerExtractor containerExtractor;
    private final boolean cache;

    public TestGetXMLStreamReader(OMMetaFactory metaFactory, XMLSample file, BuilderFactory builderFactory, OMContainerExtractor containerExtractor, boolean cache) {
        super(metaFactory, file);
        this.builderFactory = builderFactory;
        this.containerExtractor = containerExtractor;
        this.cache = cache;
        builderFactory.addTestParameters(this);
        containerExtractor.addTestParameters(this);
        this.addTestParameter("cache", cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void runTest() throws Throwable {
        try (InputStream in = this.file.getInputStream();
             XMLStreamReader expected = StAXUtils.createXMLStreamReader((StAXParserConfiguration)TEST_PARSER_CONFIGURATION, (String)this.file.getUrl().toString(), (InputStream)in);
             OMXMLParserWrapper builder = this.builderFactory.getBuilder(this.metaFactory, new InputSource(this.file.getUrl().toString()));){
            XMLStreamReader actual = this.containerExtractor.getContainer(builder).getXMLStreamReader(this.cache);
            XMLStreamReaderComparator comparator = new XMLStreamReaderComparator(this.containerExtractor.filter(expected), this.containerExtractor.filter(actual));
            this.builderFactory.configureXMLStreamReaderComparator(comparator);
            comparator.compare();
        }
    }
}

