/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.builder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.mime.MultipartBody;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.testutils.io.InstrumentedInputStream;
import org.apache.axiom.ts.AxiomTestCase;

public class TestRootPartStreaming
extends AxiomTestCase {
    public TestRootPartStreaming(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMElement orgRoot = factory.createOMElement("root", null);
        for (int i = 0; i < 10000; ++i) {
            factory.createOMElement("child", null, (OMContainer)orgRoot).setText("Some text content");
        }
        OMOutputFormat format = new OMOutputFormat();
        format.setDoOptimize(true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        orgRoot.serialize((OutputStream)baos, format);
        InstrumentedInputStream in = new InstrumentedInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        OMXMLParserWrapper builder = OMXMLBuilderFactory.createOMBuilder((OMFactory)factory, (StAXParserConfiguration)StAXParserConfiguration.DEFAULT, (MultipartBody)MultipartBody.builder().setInputStream((InputStream)in).setContentType(format.getContentType()).build());
        OMElement root = builder.getDocumentElement();
        long count1 = in.getCount();
        XMLStreamReader reader = root.getXMLStreamReader(false);
        while (reader.hasNext()) {
            reader.next();
        }
        long count2 = in.getCount();
        TestRootPartStreaming.assertTrue((count1 < count2 / 2L ? 1 : 0) != 0);
    }
}

