/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.builder;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.blob.Blobs;
import org.apache.axiom.blob.MemoryBlob;
import org.apache.axiom.blob.MemoryBlobOutputStream;
import org.apache.axiom.mime.MultipartBody;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.testutils.RandomUtils;
import org.apache.axiom.testutils.blob.RandomBlob;
import org.apache.axiom.testutils.io.IOTestUtils;
import org.apache.axiom.ts.AxiomTestCase;

public class TestReadAttachmentBeforeRootPartComplete
extends AxiomTestCase {
    public TestReadAttachmentBeforeRootPartComplete(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMElement orgRoot = factory.createOMElement("root", null);
        OMElement orgChild1 = factory.createOMElement("child1", null, (OMContainer)orgRoot);
        RandomBlob orgBlob = new RandomBlob(54321L, 4096L);
        orgChild1.addChild((OMNode)factory.createOMText((Blob)orgBlob, true));
        OMElement orgChild2 = factory.createOMElement("child2", null, (OMContainer)orgRoot);
        String s = RandomUtils.randomString((int)131072);
        orgChild2.setText(s);
        OMOutputFormat format = new OMOutputFormat();
        format.setDoOptimize(true);
        MemoryBlob xop = Blobs.createMemoryBlob();
        MemoryBlobOutputStream out = xop.getOutputStream();
        orgRoot.serialize((OutputStream)out, format);
        out.close();
        OMXMLParserWrapper builder = OMXMLBuilderFactory.createOMBuilder((OMFactory)factory, (StAXParserConfiguration)StAXParserConfiguration.NON_COALESCING, (MultipartBody)MultipartBody.builder().setInputStream((InputStream)xop.getInputStream()).setContentType(format.getContentType()).build());
        OMElement root = builder.getDocumentElement();
        OMElement child1 = (OMElement)root.getFirstOMChild();
        OMText text = (OMText)child1.getFirstOMChild();
        TestReadAttachmentBeforeRootPartComplete.assertTrue((boolean)text.isBinary());
        Blob blob = text.getBlob();
        IOTestUtils.compareStreams((InputStream)orgBlob.getInputStream(), (InputStream)blob.getInputStream());
        OMElement child2 = (OMElement)child1.getNextOMSibling();
        TestReadAttachmentBeforeRootPartComplete.assertFalse((boolean)child2.isComplete());
        TestReadAttachmentBeforeRootPartComplete.assertEquals((String)s, (String)child2.getText());
    }
}

