/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.builder;

import com.google.common.truth.Truth;
import java.io.InputStream;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.DeferredParsingException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.testutils.InvocationCounter;
import org.apache.axiom.ts.AxiomTestCase;

public class TestInvalidXML
extends AxiomTestCase {
    public TestInvalidXML(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        DeferredParsingException exception2;
        DeferredParsingException exception;
        XMLStreamReader originalReader = StAXUtils.createXMLStreamReader((InputStream)TestInvalidXML.class.getResourceAsStream("invalid_xml.xml"));
        InvocationCounter invocationCounter = new InvocationCounter();
        XMLStreamReader reader = (XMLStreamReader)invocationCounter.createProxy((Object)originalReader);
        OMElement element = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (XMLStreamReader)reader).getDocumentElement();
        try {
            element.getNextOMSibling();
            exception = null;
        }
        catch (DeferredParsingException ex) {
            exception = ex;
        }
        Truth.assertThat((Throwable)exception).isNotNull();
        TestInvalidXML.assertTrue((invocationCounter.getInvocationCount() > 0 ? 1 : 0) != 0);
        invocationCounter.reset();
        try {
            element.getNextOMSibling();
            exception2 = null;
        }
        catch (DeferredParsingException ex) {
            exception2 = ex;
        }
        Truth.assertThat((Integer)invocationCounter.getInvocationCount()).isEqualTo((Object)0);
        Truth.assertThat((Throwable)exception2).isNotNull();
        Truth.assertThat((String)exception2.getMessage()).isEqualTo((Object)exception.getMessage());
    }
}

