/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.builder;

import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.om.builder.NamespaceDeclarationFilter;

public class TestCreateStAXOMBuilderNamespaceRepairing
extends AxiomTestCase {
    public TestCreateStAXOMBuilderNamespaceRepairing(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        XMLStreamReader reader = StAXUtils.createXMLStreamReader((Reader)new StringReader("<p:root xmlns:p='urn:ns1' xmlns:q='urn:ns2'><child q:attr='value'/></p:root>"));
        OMElement element = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (XMLStreamReader)((Object)new NamespaceDeclarationFilter(reader))).getDocumentElement();
        Iterator it = element.getAllDeclaredNamespaces();
        TestCreateStAXOMBuilderNamespaceRepairing.assertTrue((boolean)it.hasNext());
        OMNamespace ns = (OMNamespace)it.next();
        TestCreateStAXOMBuilderNamespaceRepairing.assertEquals((String)"p", (String)ns.getPrefix());
        TestCreateStAXOMBuilderNamespaceRepairing.assertEquals((String)"urn:ns1", (String)ns.getNamespaceURI());
        TestCreateStAXOMBuilderNamespaceRepairing.assertFalse((boolean)it.hasNext());
        OMElement child = element.getFirstElement();
        it = child.getAllDeclaredNamespaces();
        TestCreateStAXOMBuilderNamespaceRepairing.assertTrue((boolean)it.hasNext());
        ns = (OMNamespace)it.next();
        TestCreateStAXOMBuilderNamespaceRepairing.assertEquals((String)"q", (String)ns.getPrefix());
        TestCreateStAXOMBuilderNamespaceRepairing.assertEquals((String)"urn:ns2", (String)ns.getNamespaceURI());
        TestCreateStAXOMBuilderNamespaceRepairing.assertFalse((boolean)it.hasNext());
    }
}

