/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.builder;

import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import org.apache.axiom.mime.MultipartBody;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.xml.XOPSample;

public class TestCreateOMBuilderXOP
extends AxiomTestCase {
    private final XOPSample sample;
    private final boolean build;

    public TestCreateOMBuilderXOP(OMMetaFactory metaFactory, XOPSample sample, boolean build) {
        super(metaFactory);
        this.sample = sample;
        this.addTestParameter("file", sample.getName());
        this.build = build;
        this.addTestParameter("build", build);
    }

    protected void runTest() throws Throwable {
        MultipartBody mb = MultipartBody.builder().setInputStream(this.sample.getInputStream()).setContentType(this.sample.getContentType()).build();
        OMElement content = OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (StAXParserConfiguration)StAXParserConfiguration.DEFAULT, (MultipartBody)mb).getDocumentElement();
        if (this.build) {
            content.build();
        }
        ((XMLSubject)Truth.assertAbout((Subject.Factory)XMLTruth.xml()).that(XMLTruth.xml(OMElement.class, (Object)content))).hasSameContentAs((Object)this.sample.getInlinedMessage());
    }
}

