/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.builder;

import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.ConformanceTestCase;
import org.apache.axiom.ts.jaxp.dom.DOMImplementation;
import org.apache.axiom.ts.jaxp.sax.SAXImplementation;
import org.apache.axiom.ts.xml.XMLSample;
import org.xml.sax.InputSource;

public class TestCreateOMBuilderFromSAXSource
extends ConformanceTestCase {
    private final SAXImplementation implementation;
    private final Boolean expandEntityReferences;

    public TestCreateOMBuilderFromSAXSource(OMMetaFactory metaFactory, XMLSample file, SAXImplementation implementation, Boolean expandEntityReferences) {
        super(metaFactory, file);
        this.implementation = implementation;
        this.addTestParameter("implementation", implementation.getName());
        this.expandEntityReferences = expandEntityReferences;
        if (expandEntityReferences != null) {
            this.addTestParameter("expandEntityReferences", expandEntityReferences);
        }
    }

    protected void runTest() throws Throwable {
        SAXParserFactory factory = this.implementation.newSAXParserFactory();
        factory.setNamespaceAware(true);
        factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        SAXParser parser = factory.newSAXParser();
        SAXSource source = new SAXSource(parser.getXMLReader(), new InputSource(this.file.getUrl().toString()));
        OMXMLParserWrapper builder = this.expandEntityReferences == null ? OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (Source)source) : OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (SAXSource)source, (boolean)this.expandEntityReferences);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        builder.getDocument().serialize((OutputStream)baos);
        InputSource actual = new InputSource();
        actual.setByteStream(new ByteArrayInputStream(baos.toByteArray()));
        actual.setSystemId(this.file.getUrl().toString());
        ((XMLSubject)Truth.assertAbout((Subject.Factory)XMLTruth.xml()).that((Object)actual)).ignoringWhitespaceInPrologAndEpilog().expandingEntityReferences(this.expandEntityReferences == null ? false : this.expandEntityReferences).hasSameContentAs((Object)DOMImplementation.XERCES.parse(new InputSource(this.file.getUrl().toString()), this.expandEntityReferences == null || this.expandEntityReferences != false));
    }
}

