/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamedInformationItem;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.ts.AxiomTestCase;

public abstract class SetNamespaceTestCase
extends AxiomTestCase {
    private final String namespaceURI;
    private final String prefix;
    private final String prefixInScope;
    private final boolean invalid;
    private final String expectedPrefix;
    private final boolean expectNSDecl;

    public SetNamespaceTestCase(OMMetaFactory metaFactory, String namespaceURI, String prefix, String prefixInScope, boolean invalid, String expectedPrefix, boolean expectNSDecl) {
        super(metaFactory);
        this.namespaceURI = namespaceURI;
        this.prefix = prefix;
        this.prefixInScope = prefixInScope;
        this.invalid = invalid;
        this.expectedPrefix = expectedPrefix;
        this.expectNSDecl = expectNSDecl;
        if (namespaceURI != null) {
            this.addTestParameter("uri", namespaceURI);
        }
        if (prefix != null) {
            this.addTestParameter("prefix", prefix);
        }
        if (prefixInScope != null) {
            this.addTestParameter("prefixInScope", prefixInScope);
        }
        this.addTestParameter("invalid", invalid);
    }

    protected abstract boolean context();

    protected abstract OMNamedInformationItem node(OMFactory var1, OMElement var2);

    protected abstract void setNamespace(OMNamedInformationItem var1, OMNamespace var2);

    protected final void runTest() throws Throwable {
        String expectedPrefix;
        OMElement element;
        OMFactory factory = this.metaFactory.getOMFactory();
        if (this.context()) {
            OMNamespace dummyNS = factory.createOMNamespace("__dummy__", "__dummy__");
            OMElement parent = factory.createOMElement("parent", dummyNS);
            element = factory.createOMElement("test", dummyNS, (OMContainer)parent);
            if (this.prefixInScope != null) {
                if (this.prefixInScope.length() == 0) {
                    parent.declareDefaultNamespace(this.namespaceURI);
                } else {
                    parent.declareNamespace(this.namespaceURI, this.prefixInScope);
                }
            }
        } else {
            element = null;
        }
        OMNamedInformationItem node = this.node(factory, element);
        OMNamespace ns = this.namespaceURI == null ? null : factory.createOMNamespace(this.namespaceURI, this.prefix);
        try {
            this.setNamespace(node, ns);
            if (this.invalid) {
                SetNamespaceTestCase.fail((String)"Expected IllegalArgumentException");
            }
        }
        catch (IllegalArgumentException ex) {
            if (this.invalid) {
                return;
            }
            throw ex;
        }
        if (this.expectedPrefix == null) {
            expectedPrefix = node.getPrefix();
            SetNamespaceTestCase.assertNotNull((Object)expectedPrefix);
            SetNamespaceTestCase.assertFalse((expectedPrefix.length() == 0 ? 1 : 0) != 0);
        } else {
            expectedPrefix = this.expectedPrefix;
            if (expectedPrefix.length() == 0) {
                SetNamespaceTestCase.assertNull((Object)node.getPrefix());
            } else {
                SetNamespaceTestCase.assertEquals((String)expectedPrefix, (String)node.getPrefix());
            }
        }
        if (this.namespaceURI == null || this.namespaceURI.length() == 0) {
            SetNamespaceTestCase.assertNull((Object)node.getNamespace());
        } else {
            OMNamespace actualNS = node.getNamespace();
            SetNamespaceTestCase.assertEquals((String)expectedPrefix, (String)actualNS.getPrefix());
            SetNamespaceTestCase.assertEquals((String)this.namespaceURI, (String)actualNS.getNamespaceURI());
        }
        if (this.namespaceURI == null || this.namespaceURI.length() == 0) {
            SetNamespaceTestCase.assertNull((Object)node.getNamespaceURI());
        } else {
            SetNamespaceTestCase.assertEquals((String)this.namespaceURI, (String)node.getNamespaceURI());
        }
        QName qname = node.getQName();
        SetNamespaceTestCase.assertEquals((String)expectedPrefix, (String)qname.getPrefix());
        SetNamespaceTestCase.assertEquals((String)(this.namespaceURI == null ? "" : this.namespaceURI), (String)qname.getNamespaceURI());
        if (element != null) {
            Iterator it = element.getAllDeclaredNamespaces();
            if (this.expectNSDecl) {
                SetNamespaceTestCase.assertTrue((boolean)it.hasNext());
                OMNamespace decl = (OMNamespace)it.next();
                SetNamespaceTestCase.assertEquals((String)expectedPrefix, (String)decl.getPrefix());
                SetNamespaceTestCase.assertEquals((String)(this.namespaceURI == null ? "" : this.namespaceURI), (String)decl.getNamespaceURI());
            }
            SetNamespaceTestCase.assertFalse((boolean)it.hasNext());
        }
    }
}

