/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om;

import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMInformationItem;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.DigestGenerator;
import org.apache.axiom.testutils.DigestUtils;
import org.apache.axiom.ts.AxiomTestCase;

public abstract class DigestTestCase
extends AxiomTestCase {
    private final String algorithm;
    private final String expectedDigest;

    public DigestTestCase(OMMetaFactory metaFactory, String algorithm, String expectedDigest) {
        super(metaFactory);
        this.algorithm = algorithm;
        this.expectedDigest = expectedDigest;
    }

    protected final void runTest() throws Throwable {
        OMInformationItem node = this.createInformationItem();
        DigestGenerator digestGenerator = new DigestGenerator();
        byte[] digest = node instanceof OMDocument ? digestGenerator.getDigest((OMDocument)node, this.algorithm) : (node instanceof OMAttribute ? digestGenerator.getDigest((OMAttribute)node, this.algorithm) : digestGenerator.getDigest((OMNode)node, this.algorithm));
        DigestTestCase.assertEquals((String)this.expectedDigest, (String)DigestUtils.toHexString((byte[])digest));
    }

    protected abstract OMInformationItem createInformationItem() throws Exception;
}

