/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dimension.serialization;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.core.stream.stax.StAX;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.testutils.suite.MatrixTestCase;
import org.apache.axiom.ts.dimension.serialization.SerializationStrategy;
import org.apache.axiom.ts.dimension.serialization.XML;
import org.apache.axiom.ts.dimension.serialization.XMLAsByteArray;

public class SerializeToXMLStreamWriter
extends SerializationStrategy {
    private final boolean cache;

    SerializeToXMLStreamWriter(boolean cache) {
        this.cache = cache;
    }

    public void addTestParameters(MatrixTestCase testCase) {
        testCase.addTestParameter("serializationStrategy", "XMLStreamWriter");
        testCase.addTestParameter("cache", this.cache);
    }

    @Override
    public XML serialize(OMContainer container) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String encoding = null;
        if (container instanceof OMDocument) {
            encoding = ((OMDocument)container).getXMLEncoding();
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        XMLStreamWriter writer = StAX.createXMLStreamWriter((OutputStream)baos, (String)encoding);
        if (this.cache) {
            container.serialize(writer);
        } else {
            container.serializeAndConsume(writer);
        }
        writer.close();
        return new XMLAsByteArray(baos.toByteArray());
    }

    @Override
    public boolean isPush() {
        return true;
    }

    @Override
    public boolean isCaching() {
        return this.cache;
    }

    @Override
    public boolean supportsInternalSubset() {
        return true;
    }
}

