/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dimension.serialization;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.testutils.suite.MatrixTestCase;
import org.apache.axiom.ts.dimension.serialization.SerializationStrategy;
import org.apache.axiom.ts.dimension.serialization.XML;
import org.apache.axiom.ts.dimension.serialization.XMLAsByteArray;

public class SerializeToOutputStream
extends SerializationStrategy {
    private final boolean cache;

    SerializeToOutputStream(boolean cache) {
        this.cache = cache;
    }

    public void addTestParameters(MatrixTestCase testCase) {
        testCase.addTestParameter("serializationStrategy", "OutputStream");
        testCase.addTestParameter("cache", this.cache);
    }

    @Override
    public XML serialize(OMContainer container) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        container.serialize((OutputStream)baos, this.cache);
        return new XMLAsByteArray(baos.toByteArray());
    }

    @Override
    public boolean isPush() {
        return true;
    }

    @Override
    public boolean isCaching() {
        return this.cache;
    }

    @Override
    public boolean supportsInternalSubset() {
        return true;
    }
}

