/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dimension;

import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.testing.multiton.Multiton;
import org.apache.axiom.testutils.suite.Dimension;
import org.apache.axiom.testutils.suite.MatrixTestCase;
import org.apache.axiom.ts.dimension.serialization.SerializationStrategy;
import org.junit.Assert;

public abstract class ExpansionStrategy
extends Multiton
implements Dimension {
    public static final ExpansionStrategy DONT_EXPAND = new ExpansionStrategy(){

        public void addTestParameters(MatrixTestCase testCase) {
            testCase.addTestParameter("expand", "no");
        }

        @Override
        public void apply(OMContainer container) {
            if (container instanceof OMSourcedElement) {
                Assert.assertFalse((boolean)((OMSourcedElement)container).isExpanded());
            } else {
                Assert.assertFalse((boolean)container.isComplete());
            }
        }

        @Override
        public boolean isConsumedAfterSerialization(boolean pushDS, boolean destructiveDS, SerializationStrategy serializationStrategy) {
            return (!pushDS || serializationStrategy.isPush()) && destructiveDS && !serializationStrategy.isCaching();
        }

        @Override
        public boolean isExpandedAfterSerialization(boolean pushDS, boolean destructiveDS, SerializationStrategy serializationStrategy) {
            return pushDS && !serializationStrategy.isPush() || destructiveDS && serializationStrategy.isCaching();
        }
    };
    public static final ExpansionStrategy PARTIAL = new ExpansionStrategy(){

        public void addTestParameters(MatrixTestCase testCase) {
            testCase.addTestParameter("expand", "partially");
        }

        @Override
        public void apply(OMContainer container) {
            container.getFirstOMChild();
            if (container instanceof OMSourcedElement) {
                Assert.assertTrue((boolean)((OMSourcedElement)container).isExpanded());
            }
            Assert.assertFalse((boolean)container.isComplete());
        }

        @Override
        public boolean isConsumedAfterSerialization(boolean pushDS, boolean destructiveDS, SerializationStrategy serializationStrategy) {
            return !serializationStrategy.isCaching();
        }

        @Override
        public boolean isExpandedAfterSerialization(boolean pushDS, boolean destructiveDS, SerializationStrategy serializationStrategy) {
            return true;
        }
    };
    public static final ExpansionStrategy FULL = new ExpansionStrategy(){

        public void addTestParameters(MatrixTestCase testCase) {
            testCase.addTestParameter("expand", "fully");
        }

        @Override
        public void apply(OMContainer container) {
            container.getFirstOMChild();
            container.build();
            if (container instanceof OMSourcedElement) {
                Assert.assertTrue((boolean)((OMSourcedElement)container).isExpanded());
            }
            Assert.assertTrue((boolean)container.isComplete());
        }

        @Override
        public boolean isConsumedAfterSerialization(boolean pushDS, boolean destructiveDS, SerializationStrategy serializationStrategy) {
            return false;
        }

        @Override
        public boolean isExpandedAfterSerialization(boolean pushDS, boolean destructiveDS, SerializationStrategy serializationStrategy) {
            return true;
        }
    };

    private ExpansionStrategy() {
    }

    public abstract void apply(OMContainer var1);

    public abstract boolean isConsumedAfterSerialization(boolean var1, boolean var2, SerializationStrategy var3);

    public abstract boolean isExpandedAfterSerialization(boolean var1, boolean var2, SerializationStrategy var3);
}

